// ==================================================================
// cAdmin (Console Administration)
// By: Shayk-N'-Bake
// Instruction / Credits: readme.txt (with distribution of files)
// ==================================================================

// Admin Users: (No Limit)
$cAdmin::User["admin"] = "test"; // <-- Example.

// Basic settings: (More Coming)
$cAdmin::Settings["cAdminActive"] = true; // true = Active; false = Inactive;

// Mod List: (Example list, modify to fit your server)
%i = -1;
$cAdmin::modList[%i++] = "Annihilation3";
$cAdmin::modList[%i++] = "Base";
$cAdmin::modList[%i++] = "JesterMOD";
$cAdmin::modList[%i++] = "ShifterK";
$cAdmin::modList[%i++] = "Ultra_Competition";
$cAdmin::modList[%i++] = "Ultra_RenegadesVX5";
$cAdmin::modList[%i++] = "Ultra_RenegadesVX7";
$cAdmin::modList[%i++] = "Ultra_Tribal_God";

// Mod List Info: The values listed above must match in the brackets for these vars.
//-------------------

// Annihilation 3
$cAdmin::modName["Annihilation3"] = "Annihilation 3";
$cAdmin::modConfig["Annihilation3"] = "annihilation3.cs";
$cAdmin::modFolder["Annihilation3"] = "Annihilation3";

// Base
$cAdmin::modName["Base"] = "Base";
$cAdmin::modConfig["Base"] = "serverConfig.cs";
$cAdmin::modFolder["Base"] = "Base";

// Jester
$cAdmin::modName["JesterMOD"] = "Jester";
$cAdmin::modConfig["JesterMOD"] = "JesterConfig.cs";
$cAdmin::modFolder["JesterMOD"] = "JesterMOD";

// Shifter K
$cAdmin::modName["ShifterK"] = "Shifter K";
$cAdmin::modConfig["ShifterK"] = "ShifterKConfig.cs";
$cAdmin::modFolder["ShifterK"] = "ShifterK";

// Ultra Competition
$cAdmin::modName["Ultra_Competition"] = "Ultra Competition";
$cAdmin::modConfig["Ultra_Competition"] = "UCConfig.cs";
$cAdmin::modFolder["Ultra_Competition"] = "Ultra_Competition";

// Ultra Renegades VX5
$cAdmin::modName["Ultra_RenegadesVX5"] = "Ultra Renegades VX5";
$cAdmin::modConfig["Ultra_RenegadesVX5"] = "VX5Config.cs";
$cAdmin::modFolder["Ultra_RenegadesVX5"] = "Ultra_RenegadesVX5";

// Ultra Renegades VX7
$cAdmin::modName["Ultra_RenegadesVX7"] = "Ultra Renegades VX7";
$cAdmin::modConfig["Ultra_RenegadesVX7"] = "VX7Config.cs";
$cAdmin::modFolder["Ultra_RenegadesVX7"] = "Ultra_RenegadesVX7";

// Ultra Tribal God
$cAdmin::modName["Ultra_Tribal_God"] = "Ultra Tribal God";
$cAdmin::modConfig["Ultra_Tribal_God"] = "TribalPrefs.cs";
$cAdmin::modFolder["Ultra_Tribal_God"] = "Ultra_Tribal_God";

//=============================================================================
// NO EDITING BELOW REQUIRED -- Shayk-N'-Bake
//=============================================================================

function cAdmin::buildModList()
{
	%i = 0;
	while($cAdmin::modList[%i] != "")
	{
		%i++;
	}
	$cAdmin::modCount = %i+1;
}

function cAdmin::menu(%client, %menu)
{
	if(%client.cAdmin)
	{
		cAdmin::buildModList();
		if(%menu == "c" || %menu == "C")
		{
			remoteEval(%client, "cAdminEcho", "--");
			remoteEval(%client, "cAdminEcho", "cAdmin: Session Ended.");
			return;
		}
		else if(%menu == "r" || %menu == "R")
		{
			remoteEval(%client, "cAdminEcho", "--");
			remoteEval(%client, "cAdminEcho", "cAdmin: Restarting Server..");
			cAdmin::CommenceAction(%client, "restart");
			return;
		}
		else if(%menu != "" && %menu != "c" && %menu != "C" && %menu > 0 && %menu < $cAdmin::modCount)
		{
			%mod = $cAdmin::modList[%menu-1];
			remoteEval(%client, "cAdminEcho", "--");
			remoteEval(%client, "cAdminEcho", "cAdmin: Changing Mod To " @ $cAdmin::modName[%mod] @ "..");
			cAdmin::CommenceAction(%client, "mod", %mod);
			return;
		}
		if(!%menu)
		{
			remoteEval(%client, "cAdminEcho", "--");
			remoteEval(%client, "cAdminEcho", "cAdmin Menu (choose an option #):");
			remoteEval(%client, "cAdminEcho", "----------------------------------------------------");
			%i = 0;
			while($cAdmin::modList[%i] != "")
			{
				%mod = $cAdmin::modList[%i];
				remoteEval(%client, "cAdminEcho", %i+1 @ ". " @ $cAdmin::modName[%mod]);
				%i++;
			}
			remoteEval(%client, "cAdminEcho", "R. Restart Server (Requires InfiniteSpawn Running)");
			remoteEval(%client, "cAdminEcho", "C. Cancel");
			return;
		}
	}
	else
		cAdmin::login(%client);
}

function remotecAdminCommand(%client, %command)
{
	// Crash
	%client.cAdminAttempts++;
	if(%client.cAdminAttempts > 5)
	{
		cAdmin::Ban(%client, "Temporary", "2 hours");
		return;
	}
	schedule(%client @ ".cAdminAttempts = 0;", 0.5);
	
	if(!$cAdmin::Settings["cAdminActive"])
		return;
	
	// No evals right now, but in case I ever do I don't have to worry with this.. (doubt I will anyway)
	if(String::findSubStr(%command, "\"") != -1 || String::findSubStr(%command, "\\") != -1)
	{
	 	return;
	}
	
	if(%client.cAdmin)
	{
		cAdmin::menu(%client, %command);
		Schedule::Cancel(%client @ " cAdmin Expire");
		schedule("Schedule::Add(\"cAdmin::Expire(" @ %client @ ");\", 30, \"" @ %client @ " cAdmin Expire\");", 0.5);
	}
	else
		cAdmin::login(%client, %command);
}

function cAdmin::commenceAction(%client, %action, %info)
{
	if(%action == "restart")
	{
		exec("cAdmin.s.serverOverwrites.cs");
		schedule("cAdmin::restartServer();", 10);
		CenterPrintAll("<jc><f1>Server restarting in 10 seconds..");
		schedule("CenterPrintAll(\"<jc><f1>Server restarting in 5 seconds..\");", 5);
		return;
	}
	else if(%action == "mod")
	{
		%targetLine = "+exec " @ $cAdmin::modConfig[%info] @ " -mod " @ $cAdmin::modFolder[%info] @ " -dedicated";
		$targetLine = %targetLine;
		export("$targetLine", "config\\cAdmin.s.modSetting.cs", false);
		exec("cAdmin.s.serverOverwrites.cs");
		schedule("cAdmin::restartServer();", 10);
		CenterPrintAll("<jc><f1>Server changing to mod: <f2>" @ $cAdmin::modName[%info] @ "\n<f0>Restarting in 10 seconds..");
		schedule("CenterPrintAll(\"<jc><f1>Server changing to mod: <f2>" @ $cAdmin::modName[%info] @ "\n<f0>Restarting in 5 seconds..\");", 5);
		return;
	}
}

function cAdmin::restartServer()
{
	for(%cl = Client::getFirst(); %cl != -1; %cl = Client::getNext(%cl))
		cAdmin::Kick(%cl);
		
	Quit();
}

function cAdmin::login(%client, %data)
{
	if(%client.cAdmin)
	{
		cAdmin::menu(%client);
		return;
	}
	else
	{
		if(%client.cLogin == "name")
		{
			%client.cName = %data;
			%client.cLogin = "pass";
			remoteEval(%client, "cAdminEcho", "--");
			remoteEval(%client, "cAdminEcho", "cAdmin: Enter Password");
		}
		else if(%client.cLogin == "pass")
		{
			%client.cPass = %data;
			%client.cLogin = "complete";
			cAdmin::verifyLogin(%client);
		}
		else
		{
			%client.cLogin = "name";
			remoteEval(%client, "cAdminEcho", "--");
			remoteEval(%client, "cAdminEcho", "Note: cAdmin requires you to log in every 30 seconds of inactivity.");
			remoteEval(%client, "cAdminEcho", "--");
			remoteEval(%client, "cAdminEcho", "cAdmin: Enter Username");
		}
	}
}

function cAdmin::verifyLogin(%client)
{
	if($cAdmin::User[%client.cName] != "" && %client.cPass == $cAdmin::User[%client.cName])
	{
		%client.cAdmin = true;
		cAdmin::menu(%client);
		Schedule::Add("cAdmin::Expire(" @ %client @ ");", 30, %client @ " cAdmin Expire");
	}
	else
	{
		%client.cAdminLoginFailures++;
		%client.cAdmin = false;
		remoteEval(%client, "cAdminEcho", "--");
		remoteEval(%client, "cAdminEcho", "cAdmin: Login Failed. Attempt has been recorded and logged. Multiple failed attempts will result in kick and possible ban.");
	}
}

function cAdmin::Expire(%client)
{
	%client.cLogin = "expired";
	%client.cAdmin = false;
	%client.cName = "";
	%client.cPass = "";
}

function cAdmin::Ban(%client, %banType, %time)
{
	%name = client::getName(%client);
	%ip = Client::trimIP(%client);
	banlist::remove(client::wPort(%client));
	
	if(%banType == "Permanent")
		banlist::addAbsolute(%ip, 0);
		
	else if(%banType == "Temporary")
	{
		if(!%time)
			%time = "2 hours";

		%banTime = convertTime(%time);
		banlist::add(%ip, %banTime);
	}
	
	if(%banType == "Permanent")
		%msgAppend = "permanently";
	else
		%msgAppend = "for " @ %time;
		
	cAdmin::Kick(%client, "You have been banned from this server " @ %msgAppend @ ".");
	banlist::export("config\\banlist.cs");
}

function cAdmin::Kick(%clientId, %msg)
{
	schedule("net::kick("@%clientId@", \""@%msg@"\");",0.2);
}

function convertTime(%time)
{
	%num = getWord(%time, 0);
	%type = getWord(%time, 1);
	
	if(%type == "seconds")
		return %num;
	else if(%type == "minutes")
		return minutesToSeconds(%num);
	else if(%type == "hours")
		return hoursToSeconds(%num);
	else if(%type == "days")
		return daysToSeconds(%num);
	else if(%type == "weeks")
		return weeksToSeconds(%num);
	else
		return hoursToSeconds(2);
}

function weeksToSeconds(%weeks)
{
	return daysToSeconds(%weeks * 7);
}
function daysToSeconds(%days)
{
	return hoursToSeconds(%days * 24);
}
function hoursToSeconds(%hours)
{
	return minutesToSeconds(%hours * 60);
}
function minutesToSeconds(%minutes)
{
	return %minutes * 60;
}
function secondsToMinutes(%seconds)
{
	return %seconds / 60;
}

function Client::trimIP(%clientId)
{
  %ipstr = client::getTransportAddress(%clientId);
  %ip = string::getSubStr(%ipstr, 0, 15);
  for(%i = 0; string::getSubStr(%ip, %i, 1) != ""; %i++)
  {
		%num = string::getSubStr(%ip, %i, 1);
		if(!String::ICompare(%num, "."))
		{
			%dot++;
			if(%dot == "3")
			{
				%finalIp = string::getSubStr(%ip, 0, %i++);
				%finalIP = %finalIP@"*";
				return %finalIP;
			}
		}
  }
  return %ip;
}

function Client::wPort(%clientId)
{
  %ipstr = client::getTransportAddress(%clientId);
  %ip = string::getSubStr(%ipstr, 3, 16);
  for(%i = 0; string::getSubStr(%ip, %i, 1) != ""; %i++)
  {
		if(string::getSubStr(%ip, %i, 1) == ":")
		{
			return "IP:"@string::getSubStr(%ip, 0, %i)@":*";
		}
  }
}

function Schedule::Add(%eval, %time, %tag) 
{
	if (%tag == "")
		%tag = %eval;	// Use function as tag if none provided.
	$Schedule::ID[%tag]++;
	$Schedule::eval[%tag] = %eval;
	schedule("Schedule::Exec(\""@escapestring(%tag)@"\", "@$Schedule::ID[%tag]@");", %time);
}

function Schedule::Exec(%tag, %id) 
{
	if ($Schedule::ID[%tag] != %id)
		return;
	%eval = $Schedule::eval[%tag];
	Schedule::Cancel(%tag);
	eval(%eval);
}

function Schedule::Cancel(%tag) 
{
	$Schedule::ID[%tag]++;
	$Schedule::eval[%tag] = "";
}